//===============================================================================
// Microsoft patterns & practices Enterprise Library
// Configuration Application Block
//===============================================================================
// Copyright  Microsoft Corporation.  All rights reserved.
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY
// OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT
// LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE.
//===============================================================================

namespace Microsoft.Practices.EnterpriseLibrary.Configuration.Factory
{
	/// <summary>
	/// Represents a factory for creating objects given it's configuration.
	/// </summary>
    public interface IObjectFactory<TObjectToCreate, TObjectConfiguration>
	{
		/// <summary>
		/// Whe implemented by a class, creats an object instance from the configuration.
		/// </summary>
		/// <param name="objectConfiguration">The configuration for the object to create.</param>
		/// <returns>The object instance</returns>
        TObjectToCreate Create(TObjectConfiguration objectConfiguration);

		/// <summary>
		/// When implemented by a class, creats an object instance from the configuration using the configuration source.
		/// </summary>
		/// <param name="objectConfiguration">The configuration for the object to create.</param>
		/// <param name="configurationSource">An <see cref="IConfigurationSource"/> object.</param>
		/// <returns>The object instance</returns>
        TObjectToCreate Create(TObjectConfiguration objectConfiguration, IConfigurationSource configurationSource);
	}
}
